<?php
// Oldalsáv eltávolítása
function remove_sidebar() {
    unregister_sidebar( 'sidebar-1' );
}
add_action( 'widgets_init', 'remove_sidebar' );

// CSS fájlok betöltése
function load_styles() {
    wp_enqueue_style( 'main-styles', get_template_directory_uri() . '/css/components/menu.css' );
    wp_enqueue_style( 'main-page', get_template_directory_uri() . '/css/page.css' );
    wp_enqueue_style( 'main-header', get_template_directory_uri() . '/css/components/header.css' );
    wp_enqueue_style( 'main-footer', get_template_directory_uri() . '/css/components/footer.css' );
    wp_enqueue_style( 'mobile-styles', get_template_directory_uri() . '/css/mobile.css', array(), '1.0', 'screen and (max-width: 768px)' );
    if( is_front_page() ) {
      wp_enqueue_style( 'main-widgets', get_template_directory_uri() . '/css/components/widgets.css' );
    }
    if( is_page( $page = '134'/*venue page*/ )) {
      wp_enqueue_style( 'venue-style', get_template_directory_uri() . '/css/components/venue.css' );
    }
    if( is_page( $page = '149'/*registration page*/ )) {
      wp_enqueue_style( 'registration-style', get_template_directory_uri() . '/css/components/registration.css' );
    }
	if( is_page( $page = '296'/*sponsors page*/ )) {
      wp_enqueue_style( 'sponsors-style', get_template_directory_uri() . '/css/components/sponsors.css' );
    }
    if( is_page( $page = '159'/*attending page*/ )) {
      wp_enqueue_style( 'attending-style', get_template_directory_uri() . '/css/components/attending.css' );
    }
}
add_action( 'wp_enqueue_scripts', 'load_styles' );

// JS fájlok betöltése
function my_theme_scripts() {
  // Hamburger menü script
  wp_enqueue_script( 'hamburger-menu', get_template_directory_uri() . '/js/hamburger-menu.js', array(), '1.0.0', true );
	if( is_front_page() ) {
  wp_enqueue_script( 'counter', get_template_directory_uri() . '/js/counter.js', array(), '1.0.0', true );
	}
  wp_enqueue_script( 'navbar', get_template_directory_uri() . '/js/navbar.js', array(), '1.0.0', true );

}
add_action( 'wp_enqueue_scripts', 'my_theme_scripts' );


// A bejegyzések címének módosítása a blogon
function custom_title( $title ) {
    if ( is_front_page() ) {
        $title = get_bloginfo( 'name' ) . ' - ' . get_bloginfo( 'description' );
    } elseif ( is_singular() ) {
        $title = get_the_title() . ' - ' . get_bloginfo( 'name' );
    }
    return $title;
}
add_filter( 'pre_get_document_title', 'custom_title' );

// Egyedi menük aktiválása
function register_my_menus() {
  register_nav_menus(
    array(
      'header-menu' => __( 'Header menu' ),
      'footer-menu' => __( 'Footer menu' )
    )
  );
}
add_action( 'init', 'register_my_menus' );

// Téma egyedi beállítások
// Egyedi logo
function mrmw_custom_logo_setup() {
	$defaults = array(
		'height'               => 100,
		'width'                => 400,
		'flex-height'          => true,
		'flex-width'           => true,
		'header-text'          => array( 'site-title', 'site-description' ),
		'unlink-homepage-logo' => true, 
	);
	add_theme_support( 'custom-logo', $defaults );
}
add_action( 'after_setup_theme', 'mrmw_custom_logo_setup' );
// Téma beállítások menü létrehozása az admin felületre
add_action( 'admin_menu', 'mrmw_add_theme_settings_page' );

function mrmw_add_theme_settings_page() {
  add_theme_page(
    'Theme settings',
    'Theme settings',
    'manage_options',
    'mrmw-theme-settings',
    'mrmw_render_theme_settings_page'
  );
}

function mrmw_render_theme_settings_page() {
  ?>
  <div class="wrap">
    <h1>Merlien Theme Settings</h1>
    <form method="post" action="options.php" enctype="multipart/form-data">
      <?php settings_fields( 'mrmw-theme-settings-group' ); ?>
      <?php do_settings_sections( 'mrmw-theme-settings' ); ?>
      <table class="form-table">
        <tr valign="top">
          <th scope="row">Webpage title</th>
          <td>
            <input type="text" name="mrmw_theme_title" value="<?php echo esc_attr( get_option( 'mrmw_theme_title' ) ); ?>" />
          </td>
        </tr>
        <tr valign="top">
          <th scope="row">Hader button title and link</th>
          <td>
            <input type="text" name="blog_button_title" value="<?php echo esc_attr( get_option( 'blog_button_title' ) ); ?>" />
            <input type="text" name="blog_link" value="<?php echo esc_attr( get_option( 'blog_link' ) ); ?>" />
          </td>
        </tr>
        <tr valign="top">
          <th scope="row">Landing page text and bg image</th>
          <td>
            <label for="event_slogan">Event slogan first</label>
            <input type="text" name="event_slogan_first" value="<?php echo esc_attr( get_option( 'event_slogan_first' ) ); ?>" />
            <br />
            <label for="event_slogan">Event slogan second</label>
            <input type="text" name="event_slogan_second" value="<?php echo esc_attr( get_option( 'event_slogan_second' ) ); ?>" />
            <br />
            <label for="event_slogan">Event slogan third</label>
            <input type="text" name="event_slogan_third" value="<?php echo esc_attr( get_option( 'event_slogan_third' ) ); ?>" />
            <br />
            <label for="slogan_bg_text">Slogan bg text</label>
            <input type="text" name="slogan_bg_text" value="<?php echo esc_attr( get_option( 'slogan_bg_text' ) ); ?>" />
            <br />
            <label for="insight_text">Insight text</label>
            <input type="text" name="insight_text" style="width: 800px;" value="<?php echo esc_attr( get_option( 'insight_text' ) ); ?>" />
          </td>
          </th>
        </tr>
        <tr valign="top">
          <th scope="row">Powered by text and link</th>
          <td>
            <label for="powered_text">Powered by text</label>
            <input type="text" name="powered_text" value="<?php echo esc_attr( get_option( 'powered_text' ) ); ?>" />
            <?php $landing_page_image = get_option('landing_page_image_upload'); ?>
            <input type="text" name="landing_page_image_upload" value="<?php echo $landing_page_image; ?>" style="display:none;"/>
            <div id="landing-page-image-container">
              <?php if($landing_page_image != ''): ?>
                <img src="<?php echo $landing_page_image; ?>" style="max-width:300px;padding: 20px;border: 1px solid lightgray;margin-top: 10px;border-radius: 5px;"/><br/>
                <p><?php echo $landing_page_image; ?></p> <!-- Új sor: Kép elérési útvonala -->
              <?php endif; ?>
              <input type="file" name="landing_page_image_upload" />
            </div>
            <label for="linked_to">Linked to</label>
            <input type="text" name="linked_to" value="<?php echo esc_attr( get_option( 'linked_to' ) ); ?>" />
          </td>
        </tr>
      </table>
      <?php submit_button(); ?>
    </form>
  </div>
  <script>
    jQuery(document).ready(function($){
      var file_frame;
      $('#landing-page-image-button').on('click', function(e){
        e.preventDefault();
        if(file_frame) file_frame.close();
        file_frame = wp.media.frames.file_frame = wp.media({
          title: 'Select an image',
          button: {
            text: 'Use this image'
          },
          multiple: false
        });
        file_frame.on('select', function(){
          var attachment = file_frame.state().get('selection').first().toJSON();
          $('#landing-page-image-container img').attr('src', attachment.url);
          $('input[name="landing_page_image_upload"]').val(attachment.url);
        });
        file_frame.open();
      });
    });
  </script>
  <?php
}

add_action( 'admin_init', 'mrmw_register_theme_settings' );

function mrmw_register_theme_settings() {
  register_setting( 'mrmw-theme-settings-group', 'mrmw_theme_title' );
  register_setting( 'mrmw-theme-settings-group', 'blog_button_title' );
  register_setting( 'mrmw-theme-settings-group', 'blog_link' );
  register_setting( 'mrmw-theme-settings-group', 'event_slogan_first' );
  register_setting( 'mrmw-theme-settings-group', 'event_slogan_second' );
  register_setting( 'mrmw-theme-settings-group', 'event_slogan_third' );
  register_setting( 'mrmw-theme-settings-group', 'slogan_bg_text' );
  register_setting( 'mrmw-theme-settings-group', 'insight_text' );
  register_setting( 'mrmw-theme-settings-group', 'powered_text' );
  register_setting( 'mrmw-theme-settings-group', 'linked_to' );
  register_setting( 'mrmw-theme-settings-group', 'landing_page_image_upload', array(
    'type'              => 'option',
    'sanitize_callback' => 'mrmw_sanitize_image_upload',
    'default'           => '',
  ) );
}

// A képfeltöltés ellenőrzése és elmentése
function mrmw_sanitize_image_upload( $input ) {
  $file = isset( $_FILES['landing_page_image_upload'] ) ? $_FILES['landing_page_image_upload'] : '';

  // Ha nem töltötték fel fájlt
  if ( empty( $file['name'] ) ) {
    $existing_image = get_option( 'landing_page_image_upload' );
    return $existing_image; // Visszaadjuk a korábban feltöltött képet, ha van
  }

  // Képfeltöltés
  $attachment_id = media_handle_upload( 'landing_page_image_upload', 0 );

  // Hibaellenőrzés
  if ( is_wp_error( $attachment_id ) ) {
    add_settings_error( 'landing_page_image_upload', 'upload_failed', 'Image upload failed. Please try again.' );
    return false;
  }

  // Kép elérési útvonalának lekérése
  $attachment_url = wp_get_attachment_url( $attachment_id );

  // Az elérési útvonal mentése az adatbázisban
  update_option( 'landing_page_image_upload', $attachment_url );

  return $attachment_url; // Visszaadjuk a kép elérési útvonalát
}



/**
 * Disable the emoji's
 */
function disable_emojis() {
  remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
  remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
  remove_action( 'wp_print_styles', 'print_emoji_styles' );
  remove_action( 'admin_print_styles', 'print_emoji_styles' ); 
  remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
  remove_filter( 'comment_text_rss', 'wp_staticize_emoji' ); 
  remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
  add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
  add_filter( 'wp_resource_hints', 'disable_emojis_remove_dns_prefetch', 10, 2 );
 }
 add_action( 'init', 'disable_emojis' );
 
 /**
  * Filter function used to remove the tinymce emoji plugin.
  * 
  * @param array $plugins 
  * @return array Difference betwen the two arrays
  */
 function disable_emojis_tinymce( $plugins ) {
  if ( is_array( $plugins ) ) {
  return array_diff( $plugins, array( 'wpemoji' ) );
  } else {
  return array();
  }
 }
 
 /**
  * Remove emoji CDN hostname from DNS prefetching hints.
  *
  * @param array $urls URLs to print for resource hints.
  * @param string $relation_type The relation type the URLs are printed for.
  * @return array Difference betwen the two arrays.
  */
 function disable_emojis_remove_dns_prefetch( $urls, $relation_type ) {
  if ( 'dns-prefetch' == $relation_type ) {
  /** This filter is documented in wp-includes/formatting.php */
  $emoji_svg_url = apply_filters( 'emoji_svg_url', 'https://s.w.org/images/core/emoji/2/svg/' );
 
 $urls = array_diff( $urls, array( $emoji_svg_url ) );
  }
 
 return $urls;
 }

// Dropdown klassz az almenükhöz
function menu_set_dropdown( $sorted_menu_items, $args ) {
  $last_top = 0;
  foreach ( $sorted_menu_items as $key => $obj ) {
      // it is a top lv item?
      if ( 0 == $obj->menu_item_parent ) {
          // set the key of the parent
          $last_top = $key;
      } else {
          $sorted_menu_items[$last_top]->classes['dropdown'] = 'dropdown';
      }
  }
  return $sorted_menu_items;
}
add_filter( 'wp_nav_menu_objects', 'menu_set_dropdown', 10, 2 );

//widget a content reszen
function register_custom_widget_area() {
  register_sidebar(
  array(
  'id' => 'new-widget-area',
  'name' => esc_html__( 'My new widget area', 'theme-domain' ),
  'description' => esc_html__( 'A new widget area made for testing purposes', 'theme-domain' ),
  'before_widget' => '<div id="%1$s" class="widget %2$s">',
  'after_widget' => '</div>',
  'before_title' => '<div class="widget-title-holder"><h3 class="widget-title">',
  'after_title' => '</h3></div>'
  )
  );
  }
  add_action( 'widgets_init', 'register_custom_widget_area' );

//HTML elemek a widget cimben
function html_widget_title( $title ) {
  //HTML tag opening/closing brackets
  $title = str_replace( '[', '<', $title );
  $title = str_replace( '[/', '</', $title );

  //<strong></strong>
  $title = str_replace( 's]', 'strong>', $title );
  //<em></em>
  $title = str_replace( 'e]', 'em>', $title );
  //<span></span>
  $title = str_replace( 'sp]', 'span>', $title );

  return $title;
}
add_filter( 'widget_title', 'html_widget_title' );

