<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo get_option('mrmw_theme_title'); ?></title>
    <?php wp_head(); ?>
	<link rel="shortcut icon" href="/wp-content/themes/mrmw/favicon.ico" />

<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-FVFC9LGW9G"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-FVFC9LGW9G');
</script>


</head>
<!-- Start of HubSpot Embed Code -->
<script type="text/javascript" id="hs-script-loader" async defer src="//js.hs-scripts.com/2817435.js"></script>
<!-- End of HubSpot Embed Code -->
<body <?php body_class(); ?>>


<?php if( is_front_page() ) { ?>
  <header id="header" class="header">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container">
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
	  <div class="site-logo" style="max-width:180px; height:auto;">
			<?php if ( function_exists( 'the_custom_logo' ) ) {
			  the_custom_logo();
			} ?>
	  </div>
	 </a>
      <div class="content">
        <nav id="navbar" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <!--<div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>' target="blank" ><?php echo get_option('blog_button_title'); ?></a></div>
          </div>-->
        </nav>
      </div>
    </div>
  </header>
  <header id="header-sticky" class="header landing sticky-navbar">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container"> 
      <div class="site-logo">
            <?php if ( function_exists( 'the_custom_logo' ) ) {
              the_custom_logo();
            } ?>
      </div>
      <div class="content">
        <nav id="navbar-sticky" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <!--<div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>' target="blank" ><?php echo get_option('blog_button_title'); ?></a></div>
          </div>-->
        </nav>
      </div>
    </div>
  </header>
<?php } ?>
<?php if( !is_front_page() ) { ?>
  <header id="header" class="header other">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container"> 
      <div class="site-logo">
            <?php if ( function_exists( 'the_custom_logo' ) ) {
              the_custom_logo();
            } ?>
      </div>
      <div class="content">
        <nav id="navbar" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <!--<div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>' target="blank" ><?php echo get_option('blog_button_title'); ?></a></div>
          </div>-->
        </nav>
      </div>
    </div>
  </header>
  <header id="header-sticky" class="header landing sticky-navbar">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container"> 
      <div class="site-logo">
            <?php if ( function_exists( 'the_custom_logo' ) ) {
              the_custom_logo();
            } ?>
      </div>
      <div class="content">
        <nav id="navbar-sticky" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <!--<div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>' target="blank" ><?php echo get_option('blog_button_title'); ?></a></div>
          </div>-->
        </nav>
      </div>
    </div>
  </header>
<?php } ?>
<?php if( is_front_page() ) { ?>
  <div id="landing-header" class="landing-header">
  <div class="video-bg">
      <video id="background-video" autoplay loop muted poster="/wp-content/themes/mrmw/images/mobile-header-background.png">
      <source src="wp-content/themes/mrmw/videos/mrmw-highlits-background.webm" type="video/mp4">
      </video>
  </div>
    <div class="landing-content">
	  <div class="header-spacer">&nbsp;</div>
      <div class="big-logo">
		<img class="big-logo-image" src="/wp-content/uploads/2023/12/MRMW-MENA-Title-sponsor-logo-For-Dark-BG.webp">
		<!--<img class="big-logo-image" src="/wp-content/themes/mrmw/images/MRMW_NA_LOGO-website.png">-->
	  </div>
	  <div class="title">
        <div class="background-text"><?php echo get_option('slogan_bg_text'); ?></div>
        <div class="title-inner">
          <span class="primary"><?php echo get_option('event_slogan_first'); ?></span>
          <span class="secondary"><?php echo get_option('event_slogan_second'); ?></span>
          <span class="third"><?php echo get_option('event_slogan_third'); ?></span></div>
      </div>
			<div class="header-spacer2">&nbsp;</div>
	  <div class="address-date">
        <span class="calendar" style="padding-right:20px;"><svg height="30px" width="20px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 29.237 29.237" xml:space="preserve" fill="#fff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> <path style="fill:#fff;" d="M7.685,24.819H8.28v-2.131h3.688v2.131h0.596v-2.131h3.862v2.131h0.597v-2.131h4.109v2.131h0.595 v-2.131h3.417v-0.594h-3.417v-3.861h3.417v-0.596h-3.417v-3.519h3.417v-0.594h-3.417v-2.377h-0.595v2.377h-4.109v-2.377h-0.597 v2.377h-3.862v-2.377h-0.596v2.377H8.279v-2.377H7.685v2.377H3.747v0.594h3.938v3.519H3.747v0.596h3.938v3.861H3.747v0.594h3.938 V24.819z M12.563,22.094v-3.861h3.862v3.861H12.563z M21.132,22.094h-4.109v-3.861h4.109V22.094z M21.132,14.118v3.519h-4.109 v-3.519C17.023,14.119,21.132,14.119,21.132,14.118z M16.426,14.118v3.519h-3.862v-3.519 C12.564,14.119,16.426,14.119,16.426,14.118z M8.279,14.118h3.688v3.519H8.279V14.118z M8.279,18.233h3.688v3.861H8.279V18.233z"></path> <path style="fill:#fff;" d="M29.207,2.504l-4.129,0.004L24.475,2.51v2.448c0,0.653-0.534,1.187-1.188,1.187h-1.388 c-0.656,0-1.188-0.533-1.188-1.187V2.514l-1.583,0.002v2.442c0,0.653-0.535,1.187-1.191,1.187h-1.388 c-0.655,0-1.188-0.533-1.188-1.187V2.517l-1.682,0.004v2.438c0,0.653-0.534,1.187-1.189,1.187h-1.389 c-0.653,0-1.188-0.533-1.188-1.187V2.525H8.181v2.434c0,0.653-0.533,1.187-1.188,1.187H5.605c-0.656,0-1.189-0.533-1.189-1.187 V2.53L0,2.534v26.153h2.09h25.06l2.087-0.006L29.207,2.504z M27.15,26.606H2.09V9.897h25.06V26.606z"></path> <path style="fill:#fff;" d="M5.605,5.303h1.388c0.163,0,0.296-0.133,0.296-0.297v-4.16c0-0.165-0.133-0.297-0.296-0.297H5.605 c-0.165,0-0.298,0.132-0.298,0.297v4.16C5.307,5.17,5.44,5.303,5.605,5.303z"></path> <path style="fill:#fff;" d="M11.101,5.303h1.389c0.164,0,0.297-0.133,0.297-0.297v-4.16c-0.001-0.165-0.134-0.297-0.298-0.297 H11.1c-0.163,0-0.296,0.132-0.296,0.297v4.16C10.805,5.17,10.938,5.303,11.101,5.303z"></path> <path style="fill:#fff;" d="M16.549,5.303h1.388c0.166,0,0.299-0.133,0.299-0.297v-4.16c-0.001-0.165-0.133-0.297-0.299-0.297 h-1.388c-0.164,0-0.297,0.132-0.297,0.297v4.16C16.252,5.17,16.385,5.303,16.549,5.303z"></path> <path style="fill:#fff;" d="M21.899,5.303h1.388c0.164,0,0.296-0.133,0.296-0.297v-4.16c0-0.165-0.132-0.297-0.296-0.297 h-1.388c-0.164,0-0.297,0.132-0.297,0.297v4.16C21.603,5.17,21.735,5.303,21.899,5.303z"></path> </g> </g> </g></svg></span><span class="address-date"><?php echo get_option('insight_text'); ?></span>
      </div>
      
      <div class="buttons">
        <?php if (!empty(get_option('powered_text'))) {?>
		<!--<div class="powered-by">
          <div class="powered-by-title">
            <?php echo get_option('powered_text'); ?>
          </div>
          <a href="<?php echo get_option('linked_to'); ?>">
            <div class="powered-logo">
            <?php 
            $landing_page_image = get_option('landing_page_image_upload');
            if ( ! empty( $landing_page_image ) ) {
              echo '<img src="' . esc_url( $landing_page_image ) . '" alt="Powered by logo">';
            }
            ?>
            
            </div>
          </a>
        </div>-->
		<?php } ?>
        <a href="/registration/">
          <div class="registration-button">
            Get Your Ticket
          </div>
        </a>
      </div>
    </div>
    <div class="counter">
      <div id="counter-inner">
        <div class="days">
          <div class="wrapper">
            <div class="count" id="counter-days"></div>
            <div class="title">Days</div>
          </div>
        </div>
        <div class="hours">
          <div class="wrapper">
            <div class="count" id="counter-hours"></div>
            <div class="title">Hours</div>
          </div>
        </div>
        <div class="minutes">
          <div class="wrapper">
            <div class="count" id="counter-minutes"></div>
            <div class="title">Minutes</div>
          </div>
        </div>
        <div class="seconds">
          <div class="wrapper">
            <div class="count" id="counter-seconds"></div>
            <div class="title">Seconds</div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '134'/*venue page*/ )) { ?>
	<div class="page-title-bar venue">
		<div class="venue-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '124'/*speakers page*/ )) { ?>
	<div class="page-title-bar speakers">
		<div class="speakers-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '130'/*agenda page*/ )) { ?>
	<div class="page-title-bar agenda">
		<div class="agenda-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '149'/*registration page*/ )) { ?>
	<div class="page-title-bar registration">
		<div class="registration-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '296'/*sponsors page*/ )) { ?>
	<div class="page-title-bar sponsors">
		<div class="sponsors-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '159'/*attending page*/ )) { ?>
	<div class="page-title-bar attending">
		<div class="attending-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
   <?php if( !is_front_page() && is_page( $page = '237'/*terms page*/ )) { ?>
	<div class="page-title-bar terms">
		<div class="terms-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '256'/*cfp page*/ )) { ?>
	<div class="page-title-bar cfp">
		<div class="cfp-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>