<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header">
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
        <div class="entry-meta">
            <?php
            printf(
                __( 'Posted on %1$s by %2$s', 'mrmw' ),
                '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark"><time class="entry-date published updated" datetime="' . esc_attr( get_the_date( 'c' ) ) . '">' . esc_html( get_the_date() ) . '</time></a>',
                '<span class="byline">' . esc_html( get_the_author() ) . '</span>'
            );
            ?>
        </div><!-- .entry-meta -->
    </header><!-- .entry-header -->
    <div class="entry-content">
        <?php
            the_content( sprintf(
                __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'mrmw' ),
                get_the_title()
            ) );

            wp_link_pages( array(
                'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'mrmw' ),
                'after'  => '</div>',
            ) );
        ?>
    </div><!-- .entry-content -->
    <footer class="entry-footer">
        <?php mrmw_entry_footer(); ?>
    </footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
