<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo get_option('mrmw_theme_title'); ?></title>
    <?php wp_head(); ?>
    
</head>
<body <?php body_class(); ?>>


<?php if( is_front_page() ) { ?>
  <header id="header" class="header">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container">
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
	  <div class="site-logo" style="max-width:180px; height:auto;">
			<?php if ( function_exists( 'the_custom_logo' ) ) {
			  the_custom_logo();
			} ?>
	  </div>
	 </a>
      <div class="content">
        <nav id="navbar" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>'><?php echo get_option('blog_button_title'); ?></a></div>
          </div>
        </nav>
      </div>
    </div>
  </header>
  <header id="header-sticky" class="header landing sticky-navbar">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container"> 
      <div class="site-logo">
            <?php if ( function_exists( 'the_custom_logo' ) ) {
              the_custom_logo();
            } ?>
      </div>
      <div class="content">
        <nav id="navbar-sticky" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>'><?php echo get_option('blog_button_title'); ?></a></div>
          </div>
        </nav>
      </div>
    </div>
  </header>
<?php } ?>
<?php if( !is_front_page() ) { ?>
  <header id="header" class="header other">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container"> 
      <div class="site-logo">
            <?php if ( function_exists( 'the_custom_logo' ) ) {
              the_custom_logo();
            } ?>
      </div>
      <div class="content">
        <nav id="navbar" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>'><?php echo get_option('blog_button_title'); ?></a></div>
          </div>
        </nav>
      </div>
    </div>
  </header>
  <header id="header-sticky" class="header landing sticky-navbar">
    <div class="mobile-background mobile-background-opened"></div>
    <div class="container"> 
      <div class="site-logo">
            <?php if ( function_exists( 'the_custom_logo' ) ) {
              the_custom_logo();
            } ?>
      </div>
      <div class="content">
        <nav id="navbar-sticky" class="navbar">

          <?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) ); ?>

          <div class="hamburger">
            <span class="bar"></span>
            <span class="bar"></span>
            <span class="bar"></span>
          </div>
          <div class="register-button">
          <div class="link"><a href='/registration/'>Registration</a></div>
          </div>
          <div class="blog-button">
          <div class="link"><a href='<?php echo get_option("blog_link"); ?>'><?php echo get_option('blog_button_title'); ?></a></div>
          </div>
        </nav>
      </div>
    </div>
  </header>
<?php } ?>
<?php if( is_front_page() ) { ?>
  <div id="landing-header" class="landing-header">
  <div class="video-bg">
      <video id="background-video" autoplay loop muted poster="/wp-content/themes/mrmw/images/mobile-header-background.png">
      <source src="wp-content/themes/mrmw/videos/mrmw-highlits-background.webm" type="video/mp4">
      </video>
  </div>
    <div class="landing-content">
	  <div class="header-spacer">&nbsp;</div>
      <div class="big-logo">
		<img class="big-logo-image" src="/wp-content/themes/mrmw/images/MRMW_NA_LOGO-website.png">
	  </div>
	  <div class="address-date">
        <?php echo get_option('insight_text'); ?>
      </div>
      <div class="title">
        <div class="background-text"><?php echo get_option('slogan_bg_text'); ?></div>
        <div class="title-inner">
          <span class="primary"><?php echo get_option('event_slogan_first'); ?></span>
          <span class="secondary"><?php echo get_option('event_slogan_second'); ?></span>
          <span class="third"><?php echo get_option('event_slogan_third'); ?></span></div>
      </div>
      <div class="buttons">
        <?php if (!empty(get_option('powered_text'))) {?>
		<div class="powered-by">
          <div class="powered-by-title">
            <?php echo get_option('powered_text'); ?>
          </div>
          <a href="<?php echo get_option('linked_to'); ?>">
            <div class="powered-logo">
            <?php 
            $landing_page_image = get_option('landing_page_image_upload');
            if ( ! empty( $landing_page_image ) ) {
              echo '<img src="' . esc_url( $landing_page_image ) . '" alt="Powered by logo">';
            }
            ?>
            
            </div>
          </a>
        </div>
		<?php } ?>
        <a href="/registration/">
          <div class="registration-button">
            Buy Ticket
          </div>
        </a>
      </div>
    </div>
    <div class="counter">
      <div id="counter-inner">
        <div class="days">
          <div class="wrapper">
            <div class="count" id="counter-days"></div>
            <div class="title">Days</div>
          </div>
        </div>
        <div class="hours">
          <div class="wrapper">
            <div class="count" id="counter-hours"></div>
            <div class="title">Hours</div>
          </div>
        </div>
        <div class="minutes">
          <div class="wrapper">
            <div class="count" id="counter-minutes"></div>
            <div class="title">Minutes</div>
          </div>
        </div>
        <div class="seconds">
          <div class="wrapper">
            <div class="count" id="counter-seconds"></div>
            <div class="title">Seconds</div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '134'/*venue page*/ )) { ?>
	<div class="page-title-bar venue">
		<div class="venue-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '124'/*speakers page*/ )) { ?>
	<div class="page-title-bar speakers">
		<div class="speakers-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '130'/*agenda page*/ )) { ?>
	<div class="page-title-bar agenda">
		<div class="agenda-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '149'/*registration page*/ )) { ?>
	<div class="page-title-bar registration">
		<div class="registration-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>
  <?php if( !is_front_page() && is_page( $page = '159'/*attending page*/ )) { ?>
	<div class="page-title-bar attending">
		<div class="attending-header-background"></div>
		<div class="container">
			<h1><?php echo get_the_title(); ?></h1>
		</div>
	</div>
  <?php } ?>